*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Ethoprophos                                          *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\SAS code Final Models\Diagnostics.SAS";
libname EPA "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\kapp data";

/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/
data ethoprop;
     set epa.ethoprop;
run;
proc sort data=ethoprop;
     by id;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Ethoprop - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=Ethoprop);
ods rtf close;


*===> Human vs. Rat;

title "model 3: Human vs. rat";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=ethoprop /*itdetails*/ tech=nrridg lis=3 ;*gconv=0;

      PARMS ha=0.3095
			hb=0.2051	
			ra=0.6685
			rb=0.9130	
			gha=0.1909	ghab=1.0546		ghb=0.1993
			gra=1.1376	grab=0.2298	grb=.4762
			S2E=0.1942;

            rha=ha+uha;
			rra=ra+ura;
            rhb=hb+uhb;
			rrb=rb+urb;
            PRED = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-3 + H_I__M + rrb*Rat*1e-3 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ura urb ~ normal([0, 0, 0, 0],	[gha*1e-2, 
												 		 ghab*1e-3, ghb*1e-2,
														 0,    	  0,   gra*1e-1,
														 0,       0,   grab, grb]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  predict pred out=Resid_HR;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Ethoprop human-rat.rtf" startpage=no;
%DiagnosticsHR(chemical=Ethoprop, model=3)
ods rtf close;
%Calculate_Ki(chemical=Ethoprop, Hadj=1e-3, Radj=1e-3);


*===> Adult vs. Infant;

title "final model 2b - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=ethoprop(where=(Human=1)) tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=.3055	adB=.2097
			ia=.3219 iB=.1841
			gha=1.8195 	ghab=1.0442 	ghb=1.9032
			S2E=0.1732;

			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-3 + H_I__M*adult + rib*1e-3*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-3, ghab*1e-3, ghb*1e-3]) SUBJECT=ID out=RandID_AI; 
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	  predict pred out=Resid_AI;
run;


ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Ethoprop Adult-Infant.rtf" startpage=no;
%DiagnosticsAI(chemical=Ethoprop, model=2);
ods rtf close;



*===> Male vs. female;

title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=ethoprop(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ma=.30 mb= 0.195
			fa=.32 fB=.21
			gha=.18 	ghab=.92 	ghb=.20
			S2E=.17;

            rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
            PRED = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-3 + H_I__M*male + rfb*female*1e-3 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-2, ghab*1e-3, ghb*1e-2]) SUBJECT=ID out=RandID_MF; 
	 ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  predict pred out=Resid_MF;
run;


ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Ethoprop Male-Female.rtf" startpage=no;
%DiagnosticsMF(chemical=Ethoprop, model=2);
ods rtf close;


*===> Caucasian vs. Others;

title "model 3: Caucasian vs. others";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=ethoprop(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
PARMS ca=.3077	cB=.2074
			ora=.3130 orB=.1975
			gca=.1884	gcab=.6476	gcb=.2316
			gora=.1735 	gorab=.1698 	gorb=.1605
			S2E=.1733;
          	rca=ca+uca;
            rcb=cB+ucb;
			rora=ora+uora;
			rorb=orB+uorb;
            PRED = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-3 + H_I__M*caucasian + rorb*otherrace*1e-3 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uca ucb uora uorb ~ normal([0, 0, 0, 0],   [gca*1e-2, 
														gcab*1e-3, gcb*1e-2, 
														0,    0,     gora*1e-2, 
														0,    0,     gorab*1e-2,   gorb*1e-2]) SUBJECT=ID out=RandID_CO; 

	  ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasian ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	  predict pred out=Resid_CO;
run;


ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Ethoprop Caucasian-Other.rtf" startpage=no;
%DiagnosticsCO(chemical=Ethoprop, model=3);
ods rtf close;
